/* Copyright (C) 1997-2001 Agilent Technologies */
/* VXIplug&play Instrument Driver for the E1459*/

#ifndef hpe1459_INCLUDE
#define hpe1459_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
/* Version A.01.05 */

/******************************************************
 * INSTR_DEVELOPER: Take out what you don't need
 ******************************************************
 */

/******  Returned error status values *****/
/* Agilent Common Error numbers start at BFFC0D00 */
#define hpe1459_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1459_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1459_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1459_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1459_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1459_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1459_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */
#define hpe1459_ERROR_NOT_LOCK_OWNER      (_VI_ERROR+0x3FFC0D08L) /* 0xBFFC0D08 */
#define hpe1459_ERROR_DAV_SET 			   (_VI_ERROR+0x3FFC0D09L) /* 0xBFFC0D09 */

/* Parameter errors not in VPP 3.4 */
#define hpe1459_INSTR_ERROR_PARAMETER9	(_VI_ERROR+0x3FFC0D20L)/* 0xBFFC0D20 */
#define hpe1459_INSTR_ERROR_PARAMETER10	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D21 */
#define hpe1459_INSTR_ERROR_PARAMETER11	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D22 */
#define hpe1459_INSTR_ERROR_PARAMETER12	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D23 */
#define hpe1459_INSTR_ERROR_PARAMETER13	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D24 */
#define hpe1459_INSTR_ERROR_PARAMETER14	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D25 */
#define hpe1459_INSTR_ERROR_PARAMETER15	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D26 */
#define hpe1459_INSTR_ERROR_PARAMETER16	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D27 */
#define hpe1459_INSTR_ERROR_PARAMETER17	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D28 */
#define hpe1459_INSTR_ERROR_PARAMETER18	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D29 */


/*Driver writer must set to maximum number of events */
#define hpe1459_EVENT_MAX	10

/* required plug and play functions from VPP-3.1*/

ViStatus _VI_FUNC hpe1459_init (ViRsrc InstrDesc, ViBoolean id_query,
                ViBoolean do_reset, ViPSession vi );
ViStatus _VI_FUNC hpe1459_close (ViSession vi);
ViStatus _VI_FUNC hpe1459_reset (ViSession vi);
ViStatus _VI_FUNC hpe1459_self_test (ViSession vi, ViPInt16 test_result,
                ViChar _VI_FAR test_message[]);
ViStatus _VI_FUNC hpe1459_error_query (ViSession vi, ViPInt32 error_number,
                ViChar _VI_FAR error_message[]);
ViStatus _VI_FUNC hpe1459_error_message (ViSession vi, ViStatus error_number,
                ViChar _VI_FAR message[]);
ViStatus _VI_FUNC hpe1459_revision_query (ViSession vi,
		ViChar _VI_FAR driver_rev[], ViChar _VI_FAR instr_rev[]);

ViStatus _VI_FUNC hpe1459_timeOut (ViSession vi, ViInt32 tmo);
ViStatus _VI_FUNC hpe1459_timeOut_Q (ViSession vi, ViPInt32 tmo);

#ifdef INSTR_CALLBACKS
typedef void (_VI_FUNCH _VI_PTR hpe1459_Handler)(ViSession vi, ViInt32 userHandle);
typedef hpe1459_Handler _VI_PTR hpe1459_PHandler;

ViStatus _VI_FUNC hpe1459_installHandler (ViSession vi, ViInt32 eventType, hpe1459_Handler Handler, ViInt32 userHandle);

ViStatus _VI_FUNC hpe1459_uninstallHandler (ViSession vi, ViInt32 eventType, hpe1459_Handler Handler, ViInt32 userHandle);
#endif


ViStatus _VI_FUNC hpe1459_enableEvent (ViSession vi, ViInt32 eventType, ViInt16 mechanism,ViInt32 context);

ViStatus _VI_FUNC hpe1459_disableEvent (ViSession vi, ViInt32 eventType, ViInt16 mechanism,ViInt32 context);


ViStatus _VI_FUNC hpe1459_getLastError(
  ViSession vi,
  ViPInt32 data);

/* VXI registers */

#define	ID_reg				0
#define	DevType_reg			2
#define Status_reg			4
#define EdgeIntr_reg		6
#define DAVStatus_reg		8
#define WDog_reg			10		/* Watch Dog reg */
#define Cmd02_reg			16		/* Command reg 0,2 */
#define CD02_reg			18		/* Chan data 0,2 */
#define PED02_reg			20		/* Pos edge detect 0,2 */
#define NED02_reg			22		/* Neg. edge detect 0,2*/
#define PM02_reg			24		/* Positive Mask 0,2 */
#define NM02_reg			26		/* Negative Mask 0,2 */
#define Deb_reg				30		/* Debounce reg */
#define Cmd13_reg			32		/* command reg 1,3 */
#define CD13_reg			34		/* Channel Data port 1,3 */
#define PED13_reg			36
#define NED13_reg			38
#define PM13_reg			40
#define NM13_reg			42
#define DebCntl_reg			46

#define Cmd_reg			16		/* Command reg 0,2 */
#define ChData_reg			18		/* Chan data 0,2 */
#define PosEdgeDet_reg			20		/* Pos edge detect 0,2 */
#define NegEdgeDet_reg			22		/* Neg. edge detect 0,2*/
#define PosMask_reg			24		/* Positive Mask 0,2 */
#define NegMask_reg			26		/* Negative Mask 0,2 */

#define	NUM_EVENTS			11

#define hpe1459_MAX_INTERFACES	2


#define hpe1459_EVENT_ERROR			0
#define hpe1459_EVENT_EDGE_0		1
#define hpe1459_EVENT_EDGE_1		2
#define hpe1459_EVENT_EDGE_2		3
#define hpe1459_EVENT_EDGE_3		4
#define hpe1459_EVENT_DAV_0			5
#define hpe1459_EVENT_DAV_1			6
#define hpe1459_EVENT_DAV_2			7
#define hpe1459_EVENT_DAV_3			8
#define hpe1459_EVENT_DAV			9
#define hpe1459_EVENT_EDGE			10
#define hpe1459_ALL_ENABLED_EVENTS	11

#define hpe1459_TRAC_NONE	0
#define hpe1459_TRAC_ERROR	1

/* events for the driver */
#define hpe1459_TRAC_STDERR 0
#define	hpe1459_TRAC_EVENTLOG	1
#define	hpe1459_TRAC_DEBUGSTRING	2
#define	hpe1459_TRAC_CALLBACK	3
#define hpe1459_TRAC_ALL	2




/******   Used by Function hpe1459_enablePort   *****/
#define  hpe1459_PORT_0  0
#define  hpe1459_PORT_1  1
#define  hpe1459_PORT_2  2
#define  hpe1459_PORT_3  3
#define  hpe1459_ENABLE_DAV  4
#define  hpe1459_ENABLE_EDGE  1


/******   Used by Function hpe1459_getAttribute   *****/
#define  hpe1459_ATTRIB_LOCK_TMO  0
#define  hpe1459_ATTRIB_TRACE_DEST  1
#define  hpe1459_ATTRIB_TRACE_LEVEL  2
#define  hpe1459_ATTRIB_EVENT_ERROR_UH  3


/******   Used by Function hpe1459_input   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */
#define  hpe1459_UNUSED  0
#define  hpe1459_CLOCK_INT  1
#define  hpe1459_CLOCK_EXT  2
#define  hpe1459_DEBOUNCE_MAX  9600
#define  hpe1459_DEBOUNCE_MIN  0


/******   Used by Function hpe1459_input_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_measDigData_Q   *****/
#define  hpe1459_CHANNEL_MAX  63
#define  hpe1459_CHANNEL_MIN  0


/******   Used by Function hpe1459_measDigPort_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_negMask   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */
#define  hpe1459_MASK_MAX  32767
#define  hpe1459_MASK_MIN  -32768


/******   Used by Function hpe1459_negMask_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_posMask   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */
/*  hpe1459_MASK_MAX  */
/*  hpe1459_MASK_MIN  */


/******   Used by Function hpe1459_posMask_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_sensEvenNedg_Q   *****/
/*  hpe1459_CHANNEL_MAX  */
/*  hpe1459_CHANNEL_MIN  */


/******   Used by Function hpe1459_sensEvenPedg_Q   *****/
/*  hpe1459_CHANNEL_MAX  */
/*  hpe1459_CHANNEL_MIN  */


/******   Used by Function hpe1459_sensNegPortTran_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_sensPosPortTran_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_sensRegState_Q   *****/
/*  hpe1459_PORT_0  */
/*  hpe1459_PORT_1  */
/*  hpe1459_PORT_2  */
/*  hpe1459_PORT_3  */


/******   Used by Function hpe1459_setAttribute   *****/
/*  hpe1459_ATTRIB_LOCK_TMO  */
/*  hpe1459_ATTRIB_TRACE_DEST  */
/*  hpe1459_ATTRIB_TRACE_LEVEL  */
/*  hpe1459_ATTRIB_EVENT_ERROR_UH  */
#define  hpe1459_ATTRIB_CLEAR_CMD  4
#define  hpe1459_SA_MAX  2147483647L
#define  hpe1459_SA_MIN  0

ViStatus _VI_FUNC hpe1459_clearAllEvents  (
  ViSession vi);

ViStatus _VI_FUNC hpe1459_enablePort  (
  ViSession vi,
  ViInt32 port,
  ViInt32 data);

ViStatus _VI_FUNC hpe1459_getAttribute  (
  ViSession vi,
  ViInt32 attrib,
  ViPInt32 data);

ViStatus _VI_FUNC hpe1459_input  (
  ViSession vi,
  ViInt32 port,
  ViInt32 clock_src,
  ViReal64 deb_time);

ViStatus _VI_FUNC hpe1459_input_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 clock_src,
  ViPReal64 deb_time);

ViStatus _VI_FUNC hpe1459_measAllDigData_Q  (
  ViSession vi,
  ViPInt16 port3,
  ViPInt16 port2,
  ViPInt16 port1,
  ViPInt16 port0);

ViStatus _VI_FUNC hpe1459_measAllNegTran_Q  (
  ViSession vi,
  ViPInt16 port3,
  ViPInt16 port2,
  ViPInt16 port1,
  ViPInt16 port0);

ViStatus _VI_FUNC hpe1459_measAllPosTran_Q  (
  ViSession vi,
  ViPInt16 port3,
  ViPInt16 port2,
  ViPInt16 port1,
  ViPInt16 port0);

ViStatus _VI_FUNC hpe1459_measDigData_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean data);

ViStatus _VI_FUNC hpe1459_measDigPort_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 data);

ViStatus _VI_FUNC hpe1459_negMask  (
  ViSession vi,
  ViInt32 port,
  ViInt16 data);

ViStatus _VI_FUNC hpe1459_negMask_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 data);

ViStatus _VI_FUNC hpe1459_posMask  (
  ViSession vi,
  ViInt32 port,
  ViInt16 data);

ViStatus _VI_FUNC hpe1459_posMask_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 data);

ViStatus _VI_FUNC hpe1459_sensEvenNedg_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean data);

ViStatus _VI_FUNC hpe1459_sensEvenPedg_Q  (
  ViSession vi,
  ViInt32 channel,
  ViPBoolean data);

ViStatus _VI_FUNC hpe1459_sensNegPortTran_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 data);

ViStatus _VI_FUNC hpe1459_sensPosPortTran_Q  (
  ViSession vi,
  ViInt32 port,
  ViPInt16 data);

ViStatus _VI_FUNC hpe1459_sensRegState_Q  (
  ViSession vi,
  ViPInt16 StatusReg,
  ViPInt16 EdgeReg,
  ViPInt16 DAVReg,
  ViInt32 port,
  ViPInt16 CmdReg);

ViStatus _VI_FUNC hpe1459_setAttribute  (
  ViSession vi,
  ViInt32 attrib,
  ViInt32 data);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif

#endif /* hpe1459_INCLUDE */

